# This is an example program of how to use the Vaunix LSW DLL
# from python to control a single LSW device

from ctypes import *
vnx= cdll.VNX_switch64
vnx.fnLSW_SetTestMode(False)        # Use actual devices
DeviceIDArray = c_int * 20
Devices = DeviceIDArray()           # This array will hold the list of device handles
                                    # returned by the DLL

# GetNumDevices will determine how many LSW devices are availible
numDevices = vnx.fnLSW_GetNumDevices()
print(str(numDevices), ' device(s) found')

# GetDevInfo generates a list, stored in the devices array, of
# every availible LSW device attached to the system
# GetDevInfo will return the number of device handles in the array
dev_info = vnx.fnLSW_GetDevInfo(Devices)
print('GetDevInfo returned', str(dev_info))

# GetSerialNumber will return the devices serial number
ser_num = vnx.fnLSW_GetSerialNumber(Devices[0])
print('Serial number:', str(ser_num))

#InitDevice will prepare the device for operation
init_dev = vnx.fnLSW_InitDevice(Devices[0])
print('InitDevice returned', str(init_dev))

# SetUseExternalControl(False) will select internal control for the RF switch
internal = vnx.fnLSW_SetUseExternalControl(Devices[0], False)
print('SetUseExternalControl returned', internal)

print()

# Use GetNumSwitches to get the number of ports on the LSW device
numport = vnx.fnLSW_GetNumSwitches(Devices[0])
print('There are', numport, 'ports on this LSW device')

print('Enter the desired port: ', end = '')
# This is what allows the user to enter their desired port
port = int(input())

# This loop prevents the user from selecting a port that is not on the LSW device
while port < 1 or port > numport:
    print('Enter an integer between 1 and', numport, ': ', end = '')
    switch = int(input())

# The SetSwitch is the function that sets the port on the device
result = vnx.fnLSW_SetSwitch (Devices[0], int(port))
if result != 0:
    print('SetSwitch returned an error', result)

# The GetSwitchSetting function returns which port is currently active 
result = vnx.fnLSW_GetSwitchSetting(Devices[0])
if result < 1 or result > numport:
    print('GetActiveSwitch returned an error', result)
    
print('Active port:', result)

# This function closes the device
# You should always close the devie when finished with it
closedev = vnx.fnLSW_CloseDevice(Devices[0])
if closedev != 0:
    print('CloseDevice returned an error', closedev)
